<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Başlık Script İçinde Belirlenecek -->
    <title id="page-title">Bio Link - Dinamik Bağlantılar ve Tema</title>
    <!-- Font Awesome Ikonları -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Granit CSS Temel Stil -->
    <style>
        /* Granit CSS Temel Stil */
        :root {
            --bg-color: #f9f9f9;
            --container-bg: #fff;
            --text-color: #333;
            --link-bg: #0073e6;
            --link-hover-bg: #005bb5;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            --gradient: linear-gradient(135deg, #0073e6, #00c6ff);
            --border-radius: 15px;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--bg-color);
            color: var(--text-color);
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .container {
            text-align: center;
            background-color: var(--container-bg);
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            max-width: 300px;
            width: 100%;
            transition: background-color 0.3s ease, box-shadow 0.3s ease;
        }

        /* Kart Başlığı */
        .card-title {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 15px;
            color: var(--text-color);
        }

        /* Kart İçeriği */
        .card-content {
            margin-bottom: 20px;
        }

        .profile-pic {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            margin-bottom: 15px;
            border: 3px solid var(--container-bg);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .username {
            font-size: 24px;
            margin: 10px 0;
            color: var(--text-color);
        }

        .about {
            margin-bottom: 20px;
        }

        .about p {
            font-size: 14px;
            color: var(--text-color);
            line-height: 1.6;
        }

        .links .link {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 10px 0;
            padding: 12px;
            background: var(--gradient);
            color: #fff;
            text-decoration: none;
            border-radius: var(--border-radius);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            font-size: 14px;
        }

        .links .link i {
            margin-right: 8px;
        }

        .links .link:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
        }

        /* Kart Alt Bilgi (Footer) */
        .card-footer {
            margin-top: 20px;
            font-size: 12px;
            color: var(--text-color);
        }

        /* Tema Değiştirme Butonu */
        .theme-toggle {
            background: var(--gradient);
            color: #fff;
            border: none;
            border-radius: var(--border-radius);
            padding: 8px 16px;
            cursor: pointer;
            font-size: 14px;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .theme-toggle:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
        }

        /* Granit CSS Tema 1: Açık Tema */
        .theme-light {
            --bg-color: #f9f9f9;
            --container-bg: #fff;
            --text-color: #333;
            --link-bg: #0073e6;
            --link-hover-bg: #005bb5;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            --gradient: linear-gradient(135deg, #0073e6, #00c6ff);
        }

        /* Granit CSS Tema 2: Koyu Tema */
        .theme-dark {
            --bg-color: #1a1a1a;
            --container-bg: #2d2d2d;
            --text-color: #e0e0e0;
            --link-bg: #0073e6;
            --link-hover-bg: #005bb5;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
            --gradient: linear-gradient(135deg, #6a11cb, #2575fc);
        }

        /* Granit CSS Tema 3: Gece Mavisi */
        .theme-night-blue {
            --bg-color: #0a192f;
            --container-bg: #172a46;
            --text-color: #e0e0e0;
            --link-bg: #1f3a5c;
            --link-hover-bg: #2a4a7a;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --gradient: linear-gradient(135deg, #1f3a5c, #4a90e2);
        }

        /* Granit CSS Tema 4: Pastel Pembe */
        .theme-pastel-pink {
            --bg-color: #fff0f5;
            --container-bg: #fff;
            --text-color: #333;
            --link-bg: #ff6f61;
            --link-hover-bg: #ff4a3d;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            --gradient: linear-gradient(135deg, #ff6f61, #ff9a9e);
        }
    </style>
</head>
<body class="theme-light">
    <div class="container">
        <!-- Kart Başlığı -->
        <div class="card-title" id="card-title">Başlık</div>

        <!-- Kart İçeriği -->
        <div class="card-content">
            <!-- Profil Fotoğrafı -->
            <img src="1.gif" alt="Profil Resmi" class="profile-pic">

            <!-- Kullanıcı Adı -->
            <h1 class="username" id="username">Kullanıcı Adı</h1>

            <!-- Hakkımda Bölümü -->
            <div class="about">
                <p id="bio">Hakkımda bilgisi buraya gelecek.</p>
            </div>

            <!-- Sosyal Medya Bağlantıları -->
            <div class="links" id="links-container"></div>
        </div>

        <!-- Kart Alt Bilgi (Footer) -->
        <div class="card-footer">
            <button class="theme-toggle" id="theme-toggle">Koyu Tema</button>
            <p id="footer-text">Footer metni buraya gelecek.</p>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        // Kullanıcı Bilgileri
        const userInfo = {
            profilePic: "1.gif", // Profil fotoğrafı URL'si
            username: "Limon", // Kullanıcı adı
            bio: "Merhaba! Ben bir yazılım geliştiriciyim ve teknolojiye tutkulu biriyim. Burada benimle iletişime geçebilir ve projelerimi takip edebilirsiniz.", // Hakkımda metni
            title: "Limon'un Bio Linki", // Kart başlığı
            footerText: "© 2025 Limon. Tüm hakları saklıdır.", // Footer metni
            pageTitle: "Limon - Bio Link", // Sayfa başlığı
            links: [
                { icon: "fab fa-instagram", text: "Instagram", url: "https://instagram.com/kullaniciadi", open: true },
                { icon: "fab fa-twitter", text: "Twitter", url: "https://twitter.com/kullaniciadi", open: false },
                { icon: "fab fa-linkedin", text: "LinkedIn", url: "https://linkedin.com/in/kullaniciadi", open: true },
                { icon: "fab fa-github", text: "GitHub", url: "https://github.com/kullaniciadi", open: false },
                { icon: "fas fa-envelope", text: "E-posta", url: "mailto:email@example.com", open: true },
                { icon: "fab fa-whatsapp", text: "WhatsApp", url: "https://wa.me/901234567890", open: true }, // WhatsApp
                { icon: "fab fa-youtube", text: "YouTube", url: "https://youtube.com/kullaniciadi", open: false }, // YouTube
                { icon: "fab fa-discord", text: "Discord", url: "https://discord.gg/kullaniciadi", open: true } // Discord
            ]
        };

        // Sayfa Yüklendiğinde Kullanıcı Bilgilerini Yükle
        document.addEventListener('DOMContentLoaded', () => {
            const profilePic = document.querySelector('.profile-pic');
            const username = document.getElementById('username');
            const bio = document.getElementById('bio');
            const cardTitle = document.getElementById('card-title');
            const footerText = document.getElementById('footer-text');
            const pageTitle = document.getElementById('page-title');
            const linksContainer = document.getElementById('links-container');

            // Profil Bilgileri
            profilePic.src = userInfo.profilePic;
            username.textContent = userInfo.username;
            bio.textContent = userInfo.bio;

            // Kart Başlığı ve Footer
            cardTitle.textContent = userInfo.title;
            footerText.textContent = userInfo.footerText;

            // Sayfa Başlığı
            pageTitle.textContent = userInfo.pageTitle;

            // Bağlantıları Dinamik Olarak Ekle
            userInfo.links.forEach(link => {
                if (link.open) { // Sadece "open: true" olan bağlantıları göster
                    const linkElement = document.createElement('a');
                    linkElement.href = link.url;
                    linkElement.target = "_blank";
                    linkElement.className = "link";
                    linkElement.innerHTML = `<i class="${link.icon}"></i> ${link.text}`;
                    linksContainer.appendChild(linkElement);
                }
            });
        });

        // Tema Değiştirme Fonksiyonu
        const themeToggle = document.getElementById('theme-toggle');
        const body = document.body;
        const themes = ['theme-light', 'theme-dark', 'theme-night-blue', 'theme-pastel-pink'];
        let currentThemeIndex = 0;

        // Sayfa yüklendiğinde tema tercihini kontrol et
        document.addEventListener('DOMContentLoaded', () => {
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme && themes.includes(savedTheme)) {
                body.classList.add(savedTheme);
                currentThemeIndex = themes.indexOf(savedTheme);
                updateThemeButtonText();
            } else {
                body.classList.add(themes[0]);
            }
        });

        // Tema değiştirme butonuna tıklandığında
        themeToggle.addEventListener('click', () => {
            body.classList.remove(themes[currentThemeIndex]);
            currentThemeIndex = (currentThemeIndex + 1) % themes.length;
            body.classList.add(themes[currentThemeIndex]);
            localStorage.setItem('theme', themes[currentThemeIndex]);
            updateThemeButtonText();
        });

        // Tema buton metnini güncelle
        function updateThemeButtonText() {
            const themeNames = {
                'theme-light': 'Koyu Tema',
                'theme-dark': 'Gece Mavisi',
                'theme-night-blue': 'Pastel Pembe',
                'theme-pastel-pink': 'Açık Tema'
            };
            themeToggle.textContent = themeNames[themes[currentThemeIndex]];
        }
    </script>
</body>
</html>